---
title: Vercel AI SDK · Cloudflare AI Gateway docs
description: The Vercel AI SDK is a TypeScript library for building AI
  applications. The SDK supports many different AI providers, tools for
  streaming completions, and more.
lastUpdated: 2025-08-19T11:42:14.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ai-gateway/integrations/vercel-ai-sdk/
  md: https://developers.cloudflare.com/ai-gateway/integrations/vercel-ai-sdk/index.md
---

The [Vercel AI SDK](https://sdk.vercel.ai/) is a TypeScript library for building AI applications. The SDK supports many different AI providers, tools for streaming completions, and more.

To use Cloudflare AI Gateway inside of the AI SDK, you can configure a custom "Gateway URL" for most supported providers. Below are a few examples of how it works.

## Examples

### OpenAI

If you're using the `openai` provider in AI SDK, you can create a customized setup with `createOpenAI`, passing your OpenAI-compatible AI Gateway URL:

```typescript
import { createOpenAI } from "@ai-sdk/openai";


const openai = createOpenAI({
  baseURL: `https://gateway.ai.cloudflare.com/v1/{account_id}/{gateway_id}/openai`,
});
```

### Anthropic

If you're using the `anthropic` provider in AI SDK, you can create a customized setup with `createAnthropic`, passing your Anthropic-compatible AI Gateway URL:

```typescript
import { createAnthropic } from "@ai-sdk/anthropic";


const anthropic = createAnthropic({
  baseURL: `https://gateway.ai.cloudflare.com/v1/{account_id}/{gateway_id}/anthropic`,
});
```

### Google AI Studio

If you're using the Google AI Studio provider in AI SDK, you need to append `/v1beta` to your Google AI Studio-compatible AI Gateway URL to avoid errors. The `/v1beta` path is required because Google AI Studio's API includes this in its endpoint structure, and the AI SDK sets the model name separately. This ensures compatibility with Google's API versioning.

```typescript
import { createGoogleGenerativeAI } from "@ai-sdk/google";


const google = createGoogleGenerativeAI({
  baseURL: `https://gateway.ai.cloudflare.com/v1/{account_id}/{gateway_id}/google-ai-studio/v1beta`,
});
```

### Retrieve `log id` from AI SDK

You can access the AI Gateway `log id` from the response headers when invoking the SDK.

```typescript
const result = await generateText({
  model: anthropic("claude-3-sonnet-20240229"),
  messages: [],
});
console.log(result.response.headers["cf-aig-log-id"]);
```

### Other providers

For other providers that are not listed above, you can follow a similar pattern by creating a custom instance for any AI provider, and passing your AI Gateway URL. For help finding your provider-specific AI Gateway URL, refer to the [Supported providers page](https://developers.cloudflare.com/ai-gateway/usage/providers).
