---
title: FAQs · Cloudflare Automatic Platform Optimization docs
description: No, you do not need create Edge Cache TTL page rules. When the
  WordPress plugin is installed, APO automatically caches content for 30 days
  and invalidates on change within 30 seconds. However, because APO now supports
  cache-related page rules, make sure existing page rules do not affect the
  resources served by APO.
lastUpdated: 2025-08-11T21:16:19.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/automatic-platform-optimization/troubleshooting/faq/
  md: https://developers.cloudflare.com/automatic-platform-optimization/troubleshooting/faq/index.md
---

## Do I still need to create "Edge Cache TTL" page rules with "Cache Level: Cache Everything"?

No, you do not need create Edge Cache TTL page rules. When the WordPress plugin is installed, APO automatically caches content for 30 days and invalidates on change within 30 seconds. However, because APO now supports cache-related page rules, make sure existing page rules do not affect the resources served by APO.

## Does Origin Cache Control override APO?

No. APO ignores Origin Cache Control for caching on the Edge, but APO serves original Origin Cache Control to the client.

## Why are my browser cache control headers missing with APO?

The browser cache control headers may be missing with APO if you set your **Browser Cache TTL** to **Respect Existing Headers**. For example:

```sh
curl --silent --verbose --output /dev/null https://example.com/ --header 'Accept: text/html' 2>&1 | grep cache-control
```

```sh
< cache-control: max-age=86400, stale-while-revalidate=86400, stale-if-error=86400
```

## Is the stale-if-error directive still needed with APO?

No, the `stale-if-error` directive is not needed because the feature is built into APO.

## When I check the posts and homepage cache status, the response header shows `cf-cache-status: BYPASS`. Is APO working?

When Chrome DevTools is open, Chrome sends `Cache-Control: no-cache` by default. You can uncheck the **Disable cache (while DevTools is open)** setting and see that `cf-cache-status: HIT` and `cf-apo-via: cache` headers will be returned.

## When I check `cf-cache-status` via cURL, `MISS` and `DYNAMIC` are always returned. In my browser, I see `HIT` but other tools return `DYNAMIC`. Is this expected behavior?

Yes, this is expected behavior because the requests must contain `accept: "text/html"`.

## Are Google Fonts optimized when APO is activated?

Yes, Google Fonts are also optimized when APO is activated. You can confirm the optimization by checking the font URLs. For example, the URL will change from `https://fonts.gstatic.com/s/...` to `https://example.com/fonts.gstatic.com/s/...` when the site loads. For proxied fonts, the `cf-apo-via:proxy` header is returned.

## Can I customize query string caching with APO?

For more information on query parameters, see [Query parameters and cached responses](https://developers.cloudflare.com/automatic-platform-optimization/reference/query-parameters/).

## Why are my font URLs not being transformed?

APO will skip URL font transformation when the `content-security-policy` response header is present but missing the values described below.

To fix the problem, the `content-security-policy` header value must allow for `unsafe-inline` on either the `style-src` or `default-src` directive. For example, `Content-Security-Policy: style-src unsafe-inline;`.

The header must allow for `self` on either the `font-src` or `default-src` directive. For example, `Content-Security-Policy: font-src self;`.

## Why do I see Worker subrequests in my zone logs when using APO?

APO uses Cloudflare Workers internally to optimize content delivery, which results in Worker subrequests. These subrequests may appear in your zone logs (for example, via Logpush).

## For the APO plugin why do I see: This plugin hasn’t been tested with the latest 3 major releases of WordPress. It may no longer be maintained or supported and may have compatibility issues when used with more recent versions of WordPress.

It is not uncommon for mature plugins to see no updates for longer periods than it takes to trigger the WordPress not tested warning. The warning is for notification purposes and is not an indication that a plugin no longer works. It is still maintained.
