---
title: Upload a certificate bundle with an RSA and ECDSA certificate per custom
  hostname · Changelog
description: Upload a certificate bundle with an RSA and ECDSA certificate per
  custom hostname
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-02-14-cert-bundling-for-custom-hostnames/
  md: https://developers.cloudflare.com/changelog/2025-02-14-cert-bundling-for-custom-hostnames/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Upload a certificate bundle with an RSA and ECDSA certificate per custom hostname

Feb 14, 2025

[SSL/TLS](https://developers.cloudflare.com/ssl/)

Cloudflare has supported both RSA and ECDSA certificates across our platform for a number of years. Both certificates offer the same security, but ECDSA is more performant due to a smaller key size. However, RSA is more widely adopted and ensures compatibility with legacy clients. Instead of choosing between them, you may want both – that way, ECDSA is used when clients support it, but RSA is available if not.

Now, you can upload both an RSA and ECDSA certificate on a custom hostname via the API.

```plaintext
curl -X POST https://api.cloudflare.com/client/v4/zones/$ZONE_ID/custom_hostnames \
    -H 'Content-Type: application/json' \
    -H "X-Auth-Email: $CLOUDFLARE_EMAIL" \
    -H "X-Auth-Key: $CLOUDFLARE_API_KEY" \
    -d '{
    "hostname": "hostname",
    "ssl": {
        "custom_cert_bundle": [
            {
                "custom_certificate": "RSA Cert",
                "custom_key": "RSA Key"
            },
            {
                "custom_certificate": "ECDSA Cert",
                "custom_key": "ECDSA Key"
            }
        ],
        "bundle_method": "force",
        "wildcard": false,
        "settings": {
            "min_tls_version": "1.0"
        }
    }
}’
```

You can also:

* [Upload](https://developers.cloudflare.com/api/resources/custom_hostnames/methods/create/) an RSA or ECDSA certificate to a custom hostname with an existing ECDSA or RSA certificate, respectively.

* [Replace](https://developers.cloudflare.com/api/resources/custom_hostnames/subresources/certificate_pack/subresources/certificates/methods/update/) the RSA or ECDSA certificate with a certificate of its same type.

* [Delete](https://developers.cloudflare.com/api/resources/custom_hostnames/subresources/certificate_pack/subresources/certificates/methods/delete/) the RSA or ECDSA certificate (if the custom hostname has both an RSA and ECDSA uploaded).

This feature is available for Business and Enterprise customers who have purchased custom certificates.
