---
title: WAF Release - 2025-09-22 · Changelog
description: Cloudflare WAF managed rulesets 2025-09-22 release
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-09-22-waf-release/
  md: https://developers.cloudflare.com/changelog/2025-09-22-waf-release/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## WAF Release - 2025-09-22

Sep 22, 2025

[WAF](https://developers.cloudflare.com/waf/)

This week emphasizes two critical vendor-specific vulnerabilities: a full elevation-of-privilege in Microsoft Azure Networking (CVE-2025-54914) and a server-side template injection (SSTI) leading to remote code execution (RCE) in Skyvern (CVE-2025-49619). These are complemented by enhancements in generic detections (SQLi, SSRF) to improve baseline coverage.

**Key Findings**

* Azure (CVE-2025-54914): Vulnerability in Azure Networking allowing elevation of privileges.

* Skyvern (CVE-2025-49619): Skyvern ≤ 0.1.85 has a server-side template injection (SSTI) vulnerability in its Prompt field (workflow blocks) via Jinja2. Authenticated users with low privileges can get remote code execution (blind).

* Generic SQLi / SSRF improvements: Expanded rule coverage to detect obfuscated SQL injection patterns and SSRF across host, local, and cloud contexts.

**Impact**

These vulnerabilities allow attackers to escalate privileges or execute code under conditions where previously they could not:

* Azure CVE-2025-54914 enables an attacker from the network with no credentials to gain high-level access within Azure Networking; could lead to full compromise of networking components.

* Skyvern CVE-2025-49619 allows authenticated users with minimal privilege to exploit SSTI for remote code execution, undermining isolation of workflow components.

* The improvements for SQLi and SSRF reduce risk from common injection and request-based attacks.

| Ruleset | Rule ID | Legacy Rule ID | Description | Previous Action | New Action | Comments |
| - | - | - | - | - | - | - |
| Cloudflare Managed Ruleset | c36a425ae0c94789a9bc34f06a135cbf | 100146 | SSRF - Host - 2 | Log | Disabled | This is a New Detection |
| Cloudflare Managed Ruleset | dfa84b0aed5a4b45b953a36a57035abf | 100146B | SSRF - Local - 2 | Log | Disabled | This is a New Detection |
| Cloudflare Managed Ruleset | 276073e60c7a4b4d91faba1fbbe18d50 | 100146C | SSRF - Cloud - 2 | Log | Disabled | This is a New Detection |
| Cloudflare Managed Ruleset | 78c856218f2d40f4b5988c8c956c1961 | 100714 | Azure - Auth Bypass - CVE:CVE-2025-54914 | Log | Block | This is a New Detection |
| Cloudflare Managed Ruleset | 9f1c8d4cbf3848dbb940771bc5ced231 | 100758 | Skyvern - Remote Code Execution - CVE:CVE-2025-49619 | Log | Block | This is a New Detection |
| Cloudflare Managed Ruleset | 6be7e7829f3b43c688e1ac4284a619a1 | 100773 | Next.js - SSRF | Log | Block | This is a New Detection |
| Cloudflare Managed Ruleset | 0cc3f50216bf4b448210bcc3983ff2dd | 100774 | Adobe Commerce - Remote Code Execution - CVE:CVE-2025-54236 | Log | Block | This is a New Detection |
| Cloudflare Managed Ruleset | 53bfaeb311a049e3877fa15c0380a1a6 | 100800\_BETA | SQLi - Obfuscated Boolean - Beta | Log | Block | This rule has been merged into the original rule (ID: 7663ea44178441a0b3205c145563445f ) |
