---
title: GitHub Enterprise Cloud · Cloudflare Zero Trust docs
description: This guide covers how to configure GitHub Enterprise Cloud as a
  SAML application in Cloudflare Zero Trust.
lastUpdated: 2025-08-19T18:37:36.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/applications/configure-apps/saas-apps/github-saas/
  md: https://developers.cloudflare.com/cloudflare-one/applications/configure-apps/saas-apps/github-saas/index.md
---

This guide covers how to configure [GitHub Enterprise Cloud](https://docs.github.com/en/enterprise-cloud@latest/admin/managing-iam/using-saml-for-enterprise-iam/configuring-saml-single-sign-on-for-your-enterprise) as a SAML application in Cloudflare Zero Trust.

## Prerequisites

* An [identity provider](https://developers.cloudflare.com/cloudflare-one/identity/idp-integration/) configured in Cloudflare Zero Trust
* A GitHub Enterprise Cloud subscription
* Access to a GitHub account as an organization owner

## 1. Add a SaaS application to Cloudflare Zero Trust

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Access** > **Applications**.

2. Select **Add an application** > **SaaS** > **Select**.

3. For **Application**, select *GitHub*.

4. For the authentication protocol, select **SAML**.

5. Select **Add application**.

6. Fill in the following fields:

   * **Entity ID**: `https://github.com/orgs/<your-organization>`
   * **Assertion Consumer Service URL**: `https://github.com/orgs/<your-organization>/saml/consume`
   * **Name ID format**: *Email*

7. Copy the **SSO endpoint**, **Access Entity ID or Issuer**, and **Public key**.

8. Configure [Access policies](https://developers.cloudflare.com/cloudflare-one/policies/access/) for the application.

9. Save the application.

## 2. Create an X.509 certificate

1. Paste the **Public key** in a text editor.
2. Wrap the certificate in `-----BEGIN CERTIFICATE-----` and `-----END CERTIFICATE-----`.

## 3. Configure an identity provider and SAML SSO in GitHub Enterprise Cloud

1. In your GitHub organization page, go to **Settings** > **Authentication security**.

2. Under **SAML single sign-on**, turn on **Enable SAML authentication**.

3. Fill in the following fields:

   * **Sign on URL**: SSO endpoint from application configuration in Cloudflare Zero Trust.
   * **Issuer**: Access Entity ID or Issuer from application configuration in Cloudflare Zero Trust.
   * **Public certificate**: Paste the entire x.509 certificate from step [2. Create a x.509 certificate](#2-create-a-x509-certificate).

## 4. Test the integration

Select **Test SAML configuration**. You will be redirected to the Cloudflare Access login screen and prompted to sign in with your identity provider. When this is successful, select **Save**.

You can also turn on **Require SAML SSO authentication for all members of your organization** if you want to enforce SSO login with Cloudflare Access.
