---
title: Parameters · Cloudflare Zero Trust docs
description: Explore parameters for deploying Cloudflare WARP via MDM, including
  organization setup and device registration for Zero Trust.
lastUpdated: 2025-09-05T18:12:30.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/deployment/mdm-deployment/parameters/
  md: https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/deployment/mdm-deployment/parameters/index.md
---

Each client supports the following set of parameters as part of their deployment, regardless of the deployment mechanism.

Note

Most of the parameters listed below are also configurable in Zero Trust under **Settings** > **Devices**. In the event of conflicting settings, the WARP client will always give precedence to settings on the local device (for example, in your `mdm.xml` or `com.cloudflare.warp.plist` files).

## Required for full Cloudflare Zero Trust features

For the majority of Cloudflare Zero Trust features to work, you need to specify a team name. Examples of Cloudflare Zero Trust features which depend on the team name are [HTTP policies](https://developers.cloudflare.com/cloudflare-one/policies/gateway/http-policies/), [Browser Isolation](https://developers.cloudflare.com/cloudflare-one/policies/browser-isolation/), and [device posture](https://developers.cloudflare.com/cloudflare-one/identity/devices/).

### `organization`

Instructs the client to register the device with your organization. Registration requires authentication via an [IdP](https://developers.cloudflare.com/cloudflare-one/identity/idp-integration/) or [Service Auth](https://developers.cloudflare.com/cloudflare-one/identity/service-tokens/).

**Value Type:** `string`

**Value:** Your team name.

## Required for DNS-only policy enforcement

This field is used to enforce DNS policies when deploying the client in DoH-only mode.

### `gateway_unique_id`

Instructs the client to direct all DNS queries to a specific [Gateway DNS location](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/agentless/dns/locations/). This value is only necessary if deploying without a [team name](#organization) or in an organization with multiple DNS locations. If you do not supply a DoH subdomain, we will automatically use the default Gateway DNS location for your organization.

**Value Type:** `string`

**Value:** Your DoH subdomain.

## Organization parameters

You can use the following parameters to configure a specific Zero Trust organization.

### `auth_client_id`

Enrolls the device in your Zero Trust organization using a [service token](https://developers.cloudflare.com/cloudflare-one/identity/service-tokens/#create-a-service-token). Requires the `auth_client_secret` parameter.

**Value Type:** `string`

**Value:** Client ID of the service token.

Example configuration:

```xml
<key>auth_client_id</key>
<string>88bf3b6d86161464f6509f7219099e57.access</string>
<key>auth_client_secret</key>
<string>bdd31cbc4dec990953e39163fbbb194c93313ca9f0a6e420346af9d326b1d2a5</string>
```

Note

The service token must have *Service Auth* [device enrollment permissions](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/deployment/device-enrollment/#check-for-service-token). Allow permissions will not work for service tokens.

### `auth_client_secret`

Enrolls the device in your Zero Trust organization using a [service token](https://developers.cloudflare.com/cloudflare-one/identity/service-tokens/#create-a-service-token). Requires the `auth_client_id` parameter.

**Value Type:** `string`

**Value:** Client Secret of the service token.

### `auto_connect`

If switch has been turned off by user, the client will automatically turn itself back on after the specified number of minutes. We recommend keeping this set to a very low value — usually just enough time for a user to log in to hotel or airport Wi-Fi. If any value is specified for `auto_connect` the default state of the WARP client will always be Connected (for example, after the initial install or a reboot).

**Value Type:** `integer`

**Value:**

* `0` — Allow the switch to stay in the off position indefinitely until the user turns it back on.
* `1` to `1440` — Turn switch back on automatically after the specified number of minutes.

Note

This parameter replaces the old `enabled` property, which can no longer be used in conjunction with the new `switch_locked` and `auto_connect`. If you want to use these parameters, you must remove `enabled`.

### `display_name`

Identifies a Zero Trust organization in the WARP GUI when WARP is deployed with [multiple organizations](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/deployment/mdm-deployment/switch-organizations/). Required if the `organization` parameter is specified within a [`configs` array](#configs).

**Value Type:** `string`

**Value:** Organization nickname shown to users in the WARP GUI (for example, `Test environment`).

### `enable_post_quantum`

Feature availability

| [WARP modes](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/warp-modes/) | [Zero Trust plans](https://www.cloudflare.com/teams-pricing/) |
| - | - |
| * Gateway with WARP
* Secure Web Gateway without DNS filtering | All plans |

| System | Availability | Minimum WARP version |
| - | - | - |
| Windows | ✅ | 2025.5.735.1 |
| macOS | ✅ | 2025.5.735.1 |
| Linux | ✅ | 2025.5.735.1 |
| iOS | ✅ | 1.10 |
| Android | ✅ | 2.4 |
| ChromeOS | ✅ | 2.4 |

Use [post-quantum cryptography](https://developers.cloudflare.com/ssl/post-quantum-cryptography/) to secure connections from the device to Cloudflare's network.

**Value Type:** `boolean`

**Value:**

* `false` — (default) Disables post-quantum key agreement.
* `true` — Enables post-quantum key agreement for all traffic through the WARP tunnel.

### `onboarding`

Controls the visibility of the onboarding screens that ask the user to review the privacy policy during an application's first launch.

**Value Type:** `boolean`

**Value:**

* `false` — Screens hidden.
* `true` — (default) Screens visible.

### `override_api_endpoint`

Overrides the [IP address](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/deployment/firewall/#client-orchestration-api) used by the WARP client to communicate with the client orchestration API. If you set this parameter, be sure to update your organization's firewall to ensure the new IP is allowed through.

This functionality is intended for use with a Cloudflare China local network partner or any other third-party network partner that can maintain the integrity of network traffic. Most IT admins should not set this setting as it will redirect all API traffic to a new IP.

**Value Type:** `string`

**Value:** `1.2.3.4` — Redirect all client orchestration API calls to `1.2.3.4`.

The string must be a valid IPv4 or IPv6 address, otherwise the WARP client will fail to parse the entire MDM file.

### `override_doh_endpoint`

Note

Only supported in Gateway with DoH mode.[1](#user-content-fn-1)

Overrides the [IP address](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/deployment/firewall/#doh-ip) used by the WARP client to resolve DNS queries via DNS over HTTPS (DoH). If you set this parameter, be sure to update your organization's firewall to ensure the new IP is allowed through.

This functionality is intended for use with a Cloudflare China local network partner or any other third-party network partner that can maintain the integrity of network traffic. Most IT admins should not set this setting as it will redirect all DoH traffic to a new IP.

**Value Type:** `string`

**Value:** `1.2.3.4` — Redirect all DNS over HTTPS lookups to `1.2.3.4`.

The string must be a valid IPv4 or IPv6 address, otherwise the WARP client will fail to parse the entire MDM file.

### `override_warp_endpoint`

Overrides the [IP address and UDP port](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/deployment/firewall/#warp-ingress-ip) used by the WARP client to send traffic to Cloudflare's edge. If you set this parameter, be sure to update your organization's firewall to ensure the new IP is allowed through.

This functionality is intended for use with a Cloudflare China local network partner or any other third-party network partner that can maintain the integrity of network traffic. Most IT admins should not set this setting as it will redirect all WARP traffic to a new IP.

**Value Type:** `string`

**Value:** `203.0.113.0:500` — Redirect all WARP traffic to `203.0.113.0` on port `500`.

The string must be a valid IPv4 or IPv6 socket address (containing the IP address and port number), otherwise the WARP client will fail to parse the entire MDM file.

### `service_mode`

Allows you to choose the operational mode of the client.

**Value Type:** `string`

**Value:**

* `warp` — (default) [Gateway with WARP](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/warp-modes/#gateway-with-warp-default).

* `1dot1` — [Gateway with DoH](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/warp-modes/#gateway-with-doh).

* `proxy` — [Proxy mode](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/warp-modes/#proxy-mode). Use the `proxy_port` parameter to specify the localhost SOCKS proxy port (between `0`-`66535`). For example,

  ```xml
  <key>service_mode</key>
  <string>proxy</string>
  <key>proxy_port</key>
  <integer>44444</integer>
  ```

* `postureonly` — [Device Information Only](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/warp-modes/#device-information-only).

The service mode [Secure Web Gateway without DNS filtering](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/warp-modes/#secure-web-gateway-without-dns-filtering) is not currently supported as a value and must be configured in Zero Trust.

### `support_url`

When the WARP client is deployed via MDM, the in-app **Send Feedback** button is disabled by default. This parameter allows you to re-enable the button and direct feedback towards your organization.

**Value Type:** `string`

**Value:**

* `https://<support.example.com>` — Use an `https://` link to open your company's internal help site.
* `mailto:<yoursupport@example.com>` — Use a `mailto:` link to open your default mail client.

### `switch_locked`

Allows the user to turn off the WARP switch and disconnect the client.

**Value Type:** `boolean`

**Value:**

* `false` — (default) The user is able to turn the switch on/off at their discretion. When the switch is off, the user will not have the ability to reach sites protected by Access that leverage certain device posture checks.
* `true` — The user is prevented from turning off the switch. The WARP client will automatically start in the connected state.

On new deployments, you must also include the `auto_connect` parameter with at least a value of `0`. This will prevent clients from being deployed in the off state without a way for users to manually enable them.

Note

This parameter replaces the old `enabled` property, which can no longer be used in conjunction with the new `switch_locked` and `auto_connect`. If you want to use these parameters, you must remove `enabled`.

### `unique_client_id`

Note

Only valid for iOS and Android/ChromeOS.

Assigns a unique identifier to the device for the [device UUID posture check](https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/device-uuid).

**Value Type:** `string`

**Value:** UUID for the device (for example, `496c6124-db89-4735-bc4e-7f759109a6f1`).

## Top-level parameters

Top-level parameters determine how WARP manages device registrations.

### `configs`

Allows a user to [switch between Zero Trust organizations](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/deployment/mdm-deployment/switch-organizations/) in the WARP client GUI. The `configs` array is also required when using another [top-level parameter](#top-level-parameters) such as `multi_user` or `pre_login`, even if only one organization is specified.

**Value Type:** `array`

**Value:** An array containing one or more Zero Trust organizations.

### `multi_user`

Enables multiple user registrations on a Windows device.

**Value Type:** `boolean`

**Value:**

* `false` — (default) Only one WARP registration is stored per device. After a user logs in to WARP, their settings and identity will apply to all traffic from the device.
* `true` — Each Windows user has their own WARP registration. For more information, refer to [Multiple users on a Windows device](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/deployment/mdm-deployment/windows-multiuser/).

### `pre_login`

Allows WARP to connect with a service token before a user completes the initial Windows login. For more information, refer to [Connect WARP before Windows login](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/deployment/mdm-deployment/windows-prelogin/).

## Per-app VPN parameters (Android)

[Per-app VPN](https://support.google.com/work/android/answer/9213914?hl=en) parameters allow you to choose the Android apps that can send traffic through the WARP tunnel. Admins can configure these parameters via any MDM tool that supports deploying an Android app to managed devices or work profiles.

### `app_identifier`

An application package name/bundle identifier which uniquely identifies the app on the Google Play Store. This application will be tunneled through the WARP service.

**Value Type**: `string`

**Value**: The app identifier can be found in the ID query parameter of the specific app's Play Store URL. For example: in the case of `https://play.google.com/store/apps/details?id=com.cloudflare.cloudflareoneagent`, the app identifier for the Cloudflare One Agent app is `com.cloudflare.cloudflareoneagent`.

### `is_browser`

An optional property. `is_browser` will help the Cloudflare One Agent application decide which browser to open instead of the default browser for specific features such as re-authentication and Gateway block notifications. If needed, admins should explicitly indicate that a given `tunneled_app` is a browser, rather than relying on automatic browser detection.

**Value Type**: `boolean`

**Value**: If the value is `true`, identifies the application defined in `app_identifier` as a browser. The default value is `false` and `is_browser` is an optional property.

## Footnotes

1. Gateway with WARP is supported in client version 2025.2.664.0 and below. In version 2025.4.589.1 and above, this parameter does not apply to Gateway with WARP because all DoH traffic goes inside of the WARP tunnel. [↩](#user-content-fnref-1)
