---
title: Useful commands · Cloudflare Zero Trust docs
description: This page lists the most commonly used commands for managing local tunnels.
lastUpdated: 2025-10-20T16:28:30.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/do-more-with-tunnels/local-management/tunnel-useful-commands/
  md: https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/do-more-with-tunnels/local-management/tunnel-useful-commands/index.md
---

This page lists the most commonly used commands for managing local tunnels.

To view all CLI commands, refer to the CLI help text in your terminal. For example, to view all options for the `cloudflared tunnel` subcommand, type `cloudflared tunnel help`.

## Manage tunnels

| Command | Description |
| - | - |
| `cloudflared tunnel login` | Prompts a browser window where you can authenticate your tunnel to your Cloudflare account. |
| `cloudflared tunnel list` | Displays all active tunnels, their creation time, and associated connections. Use the `-d` flag to include deleted tunnels. |
| `cloudflared tunnel create <NAME or UUID>` | Creates a tunnel, registers it with the Cloudflare edge and generates a credential file to run this tunnel. |
| `cloudflared tunnel route` | Routes traffic through a tunnel. |
| `cloudflared tunnel route lb <NAME or UUID> <hostname> <load balancer pool>` | Adds a tunnel as an endpoint in a [load balancer pool](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/routing-to-tunnel/public-load-balancers/). A new load balancer and pool will be created if necessary.- `<hostname>`: the public-facing hostname of the load balancer, for example `lb.example.com`
- `<load balancer pool>`: the name of the [pool](https://developers.cloudflare.com/load-balancing/pools/create-pool/#create-a-pool) that will contain the tunnel endpointTo load balance traffic to a [published application](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/do-more-with-tunnels/local-management/configuration-file/#file-structure-for-published-applications), you will also need to specify the application hostname in the [endpoint host header](https://developers.cloudflare.com/load-balancing/additional-options/override-http-host-headers/) using the dashboard or API. |
| `cloudflared tunnel route ip add <IP/CIDR> <NAME or UUID>` | Adds any network route space (represented as a CIDR) to your routing table. That network space becomes reachable for requests egressing from a user's machine as long as it is using Cloudflare WARP and is enrolled in the same account that is running the tunnel chosen here. Further, those requests will be proxied to the specified tunnel, and reach an IP in the given CIDR, as long as that IP is reachable from the tunnel. To assign the IP route to a specific [Virtual Network](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/private-net/cloudflared/tunnel-virtual-networks/), use the `--vnet` option. |
| `cloudflared tunnel route ip show` (or `list`) | Shows your organization's private routing table. You can use additional flags to filter the results. |
| `cloudflared tunnel route ip delete` | Deletes the row for a given CIDR from your routing table. That portion of your network will no longer be reachable by the WARP client. |
| `cloudflared tunnel route ip get <IP/CIDR>` | Checks which row of the routing table will be used to proxy a given IP. This helps check and validate your configuration. |
| `cloudflared tunnel route dns` | Creates a DNS CNAME record hostname that points to the tunnel. |
| `cloudflared tunnel --config path/config.yaml run <NAME or UUID>` | Runs a tunnel, creating highly available connections between your server and the Cloudflare edge. You can provide name or UUID of the tunnel to run either as the last command line argument or in the configuration file using `tunnel: <NAME>`. |
| `cloudflared tunnel info <NAME or UUID>` | Displays details about the active connectors for a given tunnel identified by name of UUID. |
| `cloudflared tunnel cleanup <NAME or UUID>` | Deletes connections for tunnels with the given UUIDs or names. This is useful if you get an error trying to delete or run a tunnel after `cloudflared` is not shut down gracefully (for example, if a `kill` command is issued). |
| `cloudflared tunnel cleanup --connector-id <CONNECTOR-ID> <NAME or UUID>` | Disconnects and deletes a [cloudflared replica](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/configure-tunnels/tunnel-availability/) with the given connector ID. You can view all replicas for a tunnel by running `cloudflared tunnel info <NAME or UUID>`. |
| `cloudflared tunnel delete <NAME or UUID>` | Deletes tunnels with the given name or UUID. A tunnel cannot be deleted if it has active connections. To delete the tunnel unconditionally, use the `-f` flag. |
| `cloudflared tunnel vnet add <NAME or UUID>` | Creates a Virtual Network to which IP routes can be assigned. To make this Virtual Network the default for your Zero Trust organization, use the `-d` flag. |
| `cloudflared tunnel vnet delete <NAME or UUID>` | Deletes the Virtual Network with the given name or UUID. Before you can delete a Virtual Network, you must first delete all IP routes assigned to the Virtual Network. |
| `cloudflared tunnel vnet list` | Displays all active Virtual Networks, the default Virtual Network, and their creation times. |
| `cloudflared tail <UUID>` | Start a session to livestream logs from a specific tunnel. For more information, refer to [Tunnel logs](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/monitor-tunnels/logs/). |

## Manage `cloudflared`

| Command | Description |
| - | - |
| `cloudflared update` | Looks for a new version on the official download server. If a new version exists, it updates the agent binary and quits. Otherwise, no action is performed. This command only works if `cloudflared` was installed from GitHub binaries or from source. For more information, refer to the [update instructions](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/downloads/update-cloudflared/). |
| `cloudflared version` | Prints the `cloudflared` version number and build date. |
| `cloudflared help` | Shows a list of all top-level commands for `cloudflared`. |
