---
title: Require Gateway · Cloudflare Zero Trust docs
description: With Require Gateway, you can allow access to your applications
  only to devices enrolled in your Zero Trust organization. Unlike Require WARP,
  which will check for any WARP instance (including the consumer version),
  Require Gateway will only allow requests coming from devices whose traffic is
  filtered by your organization's Cloudflare Gateway configuration. This policy
  is best used when you want to protect company-owned assets by only allowing
  access to employees.
lastUpdated: 2025-08-22T14:24:45.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/require-gateway/
  md: https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/require-gateway/index.md
---

With Require Gateway, you can allow access to your applications only to devices enrolled in your Zero Trust organization. Unlike [Require WARP](https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/require-warp/), which will check for any WARP instance (including the consumer version), Require Gateway will only allow requests coming from devices whose traffic is filtered by your organization's Cloudflare Gateway configuration. This policy is best used when you want to protect company-owned assets by only allowing access to employees.

## Prerequisites

* Cloudflare WARP client is [deployed](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/deployment/) on the device. For a list of supported modes and operating systems, refer to [WARP Client Checks](https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/).

## 1. Enable the Gateway check

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Settings** > **WARP Client**.

2. In **WARP client checks**, select **Add new**.

3. Select **Gateway**, then select **Save**.

## 2. Add the check to an Access application

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Access** > **Applications**.

2. Locate the application for which you want to require Gateway. Select **Configure**.

3. In the **Policies** tab, create a new Access policy or edit an existing policy.

4. In the policy builder, add an Include or Require rule which uses the *Gateway* selector. Save the policy.

5. Save the Access application.

Before granting access to the application, the policy will check that the device is running the WARP client and enrolled in your Zero Trust organization.
