---
title: LinkedIn · Cloudflare Zero Trust docs
description: Cloudflare Access allows your users to use LinkedIn as their
  identity provider (IdP).
lastUpdated: 2025-06-24T20:08:43.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/identity/idp-integration/linkedin/
  md: https://developers.cloudflare.com/cloudflare-one/identity/idp-integration/linkedin/index.md
---

Cloudflare Access allows your users to use LinkedIn as their identity provider (IdP).

## Prerequisites

Sign in to your LinkedIn account before continuing. Configuring LinkedIn as a Cloudflare Access IdP requires a LinkedIn account.

## Set up LinkedIn as an IdP

To configure LinkedIn as an IdP:

1. Go to the [LinkedIn Developer Portal](https://www.linkedin.com/developers).

2. Select **Create App**.

3. On the **Create an app** page, enter an **App name** for your application.

4. Select a **LinkedIn Page** for your application or select **Create a new LinkedIn page** if you do not have a LinkedIn page.

5. Select **Upload a logo** and upload your company logo image file.

6. Select **API Terms of Use** to read the terms of use, and agree to the terms.

7. Select **Create app**.

8. In the **Products** tab of your LinkedIn application, select **Request Access** next to the **Sign In with LinkedIn using OpenID Connect** option.

9. In the **Auth** tab of your LinkedIn application, find the **Client ID** and **Client Secret**.

   ![LinkedIn account settings where you will copy the Client ID and Client Secret](https://developers.cloudflare.com/_astro/lin5.ovn9KSN7_v2VjA.webp)

10. In [Zero Trust](https://one.dash.cloudflare.com/), go to **Settings** > **Authentication**.

11. Under **Login methods**, select **Add new**.

12. Select **LinkedIn** as your IdP.

13. In the **App ID** field, copy and paste the **Client ID** from step 9. In the **Client secret** field, copy and paste the **Client secret** from step 9.

14. Select **Save**.

15. In the **Auth** tab of your LinkedIn application, go to **OAuth 2.0 settings** and select the pencil icon next to **Authorized redirect URLs for your app**.

16. Enter the following URL:

    ```txt
    https://<your-team-name>.cloudflareaccess.com/cdn-cgi/access/callback
    ```

    You can find your team name by going to [Zero Trust](https://one.dash.cloudflare.com/) > **Settings** > **Custom Pages**.

To test that your connection is working, go to [Zero Trust](https://one.dash.cloudflare.com/) > **Settings** > **Authentication** > **Login methods** > select **Test** next to your LinkedIn login method.

## Example API configuration

```json
{
  "config": {
    "client_id": "<your client id>",
    "client_secret": "<your client secret>"
  },
  "type": "linkedin",
  "name": "my example idp"
}
```
