---
title: PingFederate · Cloudflare Zero Trust docs
description: The PingFederate offering from PingIdentity provides SSO identity
  management. Cloudflare Access supports PingFederate as a SAML identity
  provider.
lastUpdated: 2025-05-15T20:34:35.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/identity/idp-integration/pingfederate-saml/
  md: https://developers.cloudflare.com/cloudflare-one/identity/idp-integration/pingfederate-saml/index.md
---

The PingFederate offering from PingIdentity provides SSO identity management. Cloudflare Access supports PingFederate as a SAML identity provider.

## Set up PingFederate as an identity provider

1. Log in to your **Ping** dashboard and go to **Applications**.

2. Select **Add Application**.

3. Select **New SAML Application**.

4. Complete the fields for name, description, and category.

These can be any value. A prompt displays to select a signing certificate to use.

1. In the **SAML attribute configuration** dialog select **Email attribute** > **urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress**.

2. Go to **SP Connections** > **SP Connection** > **Credentials**.

3. Add the matching certificate that you upload into the Cloudflare SAML configuration for Ping. Select **Include the certificate in the signature `<KEYINFO>` element**.

Note

There is an additional setting for PingFederate prior to 9.0.

1. In the **Signature Policy** tab, disable the option to **Always Sign Assertion**.

2. Leave the option enabled for **Sign Response As Required**.

This ensures that SAML destination headers are sent during the integration.

In versions 9.0 above, you can leave both of these options enabled.

1. A prompt displays to download the SAML metadata from Ping.

This file shares several fields with Cloudflare Access so you do not have to input this data.

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Settings** > **Authentication**.

2. Under **Login methods**, select **Add new**.

3. Select SAML.

4. In the **IdP Entity ID** field, enter the following URL:

```txt
https://<your-team-name>.cloudflareaccess.com/cdn-cgi/access/callback
```

You can find your team name in Zero Trust under **Settings** > **Custom Pages**.

1. Fill the other fields with values from your Ping dashboard.

2. Select **Save**.

To test that your connection is working, go to **Authentication** > **Login methods** and select **Test** next to the login method you want to test.

## Example API configuration

```json
{
  "config": {
    "issuer_url": "https://example.cloudflareaccess.com/cdn-cgi/access/callback",
    "sso_target_url": "https://sso.connect.pingidentity.com/sso/idp/SSO.saml2?idpid=aebe6668-32fe-4a87-8c2b-avcd3599a123",
    "attributes": ["PingOne.AuthenticatingAuthority", "PingOne.idpid"],
    "email_attribute_name": "",
    "sign_request": false,
    "idp_public_cert": "MIIDpDCCAoygAwIBAgIGAV2ka+55MA0GCSqGSIb3DQEBCwUAMIGSMQswCQYDVQQGEwJVUzETMBEG\nA1UEC.....GF/Q2/MHadws97cZg\nuTnQyuOqPuHbnN83d/2l1NSYKCbHt24o"
  },
  "type": "saml",
  "name": "ping saml example"
}
```
