---
title: Gateway analytics · Cloudflare Zero Trust docs
description: To see the top Allowed and Blocked requests across all of your DNS
  locations, go to Analytics > Gateway. You can filter the data by selecting a
  specific location and/or time.
lastUpdated: 2025-05-14T00:02:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/insights/analytics/gateway/
  md: https://developers.cloudflare.com/cloudflare-one/insights/analytics/gateway/index.md
---

To see the top Allowed and Blocked requests across all of your DNS locations, go to **Analytics** > **Gateway**. You can filter the data by selecting a specific location and/or time.

* **Requests** — This chart shows an overview of the number of requests made by end users within the time period you specify. It shows a breakdown of requests based on the decision Gateway took (either Allowed or Blocked).
* **Allowed requests** — This chart shows a breakdown of the five domains which received the highest number of Allowed requests. It also shows the five domains which received the lowest amount of Allowed requests. By selecting **View all** to the right of either section of the chart, you will see a list of highest 100 and lowest 100 domains ranked by number of Allowed requests.
* **Top blocked requests** — This chart shows a breakdown of the five domains which received the highest number of Blocked requests. It also shows the five domains which received the lowest number of Blocked requests. By selecting **View all** to the right of either section of the chart, you'll see a list of highest 100 and lowest 100 domains ranked by number of Blocked requests.
* **Requests by category** — The charts in this card show a breakdown of the **Top allowed categories** and the **Top blocked categories** based on the number of requests that Gateway classified as belonging to a content category.

## GraphQL queries

You can use the [GraphQL Analytics API](https://developers.cloudflare.com/analytics/graphql-api/) to query your Gateway Analytics data. Available [datasets](https://developers.cloudflare.com/analytics/graphql-api/features/data-sets/) for Gateway include:

| Dataset | Description |
| - | - |
| `gatewayL4DownstreamSessionsAdaptiveGroups` | Metrics for Gateway network sessions from user devices to the Cloudflare global network. |
| `gatewayL4UpstreamSessionsAdaptiveGroups` | Metrics for Gateway network sessions from the Cloudflare global network to user devices. |
| `gatewayL4SessionsAdaptiveGroups` | Metrics for Gateway network sessions with adaptive sampling. |
| `gatewayL7RequestsAdaptiveGroups` | Metrics for Gateway HTTP requests with adaptive sampling. |
| `gatewayResolverQueriesAdaptiveGroups` | Metrics for Gateway DNS queries with adaptive sampling. |
| `gatewayResolverByRuleExecutionPerformanceAdaptiveGroups` | Time to execute Gateway DNS policies on the Cloudflare global network. |
| `gatewayResolverByCustomResolverGroups` | Metrics for Gateway DNS queries resolved using custom resolvers. |
| `gatewayResolverByCategoryAdaptiveGroups` | Metrics for Gateway DNS queries sorted by [domain category](https://developers.cloudflare.com/cloudflare-one/policies/gateway/domain-categories/) with adaptive sampling. |

To explore the schema, you can use a GraphQL client such as [GraphiQL](https://github.com/graphql/graphiql/tree/main/packages/graphiql#readme) or [Altair](https://altairgraphql.dev/).

1. [Create an API token](https://developers.cloudflare.com/analytics/graphql-api/getting-started/authentication/api-token-auth/) with the following permissions:

   | Type | Item | Permission |
   | - | - | - |
   | Account | Account Analytics | Read |

2. In your GraphQL client, [add your API token](https://developers.cloudflare.com/analytics/graphql-api/getting-started/authentication/graphql-client-headers/) as an Authorization header.

3. Compose a query to access your Gateway Analytics datasets. For example, you can query the `gatewayResolverQueriesAdaptiveGroups` dataset to return the adaptive groups of DNS queries resolved by Gateway:

   ```graphql
   query GatewaySampleQuery($accountTag: string!, $start: Time) {
     viewer {
       accounts(filter: { accountTag: $accountTag }) {
         gatewayResolverQueriesAdaptiveGroups(
           filter: { datetime_gt: $start }
           limit: 10
         ) {
           count
           dimensions {
             queryNameReversed
             resolverDecision
           }
         }
       }
     }
   }
   ```

   [Run in GraphQL API Explorer](https://graphql.cloudflare.com/explorer?query=I4VwpgTgngBA4gQwC5gO4KgZQQWwA4A2YAiuNABQAkCAxjQPYgB2SAKggOYBcMAzkhACWTDgEIANDEr8EEJD1aCcYAJQwA3gCgYMAG6C0kDdp0xaDZkl7kAZoIIoIPdWbqMW7blPPu2nGAC+alqmphzIaBgASmC89AS6kKSQBrwAggAmCHhIgolwEIx41iahOnYOkM4wWSi5ygD6HPJSMnKBpWUESoItAIwADJ06wcOmFixjOhlKYEy8gvTzxmVloJBQAHK4YDGJELxgGVOmELHx+wAiYDSCC0snAWNPoS8dAUA\&variables=N4IghgxhD2CuB2AXAKmA5iAXCAggYTwHkBVAOWQH0BJAERABoQBnRMAJ0SxACYAGbgKwBaAIy8h3Ecl4BmTAJGYxALRABfIA)

For more information, refer to [Compose a query in GraphiQL](https://developers.cloudflare.com/analytics/graphql-api/getting-started/compose-graphql-query/).
