---
title: Get started · Cloudflare Zero Trust docs
description: This guide covers the recommended steps to start securing your
  users and devices with Cloudflare Zero Trust.
lastUpdated: 2025-07-07T17:31:26.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/setup/
  md: https://developers.cloudflare.com/cloudflare-one/setup/index.md
---

This guide covers the recommended steps to start securing your users and devices with Cloudflare Zero Trust.

Note

To get started with a specific use case, refer to our [implementation guides](https://developers.cloudflare.com/cloudflare-one/implementation-guides/).

## Prerequisites

Sign up for a [Cloudflare account](https://dash.cloudflare.com/sign-up).

## Create a Zero Trust organization

1. In the [Cloudflare dashboard](https://dash.cloudflare.com/), select **Zero Trust**.

   [Go to **Zero Trust**](https://one.dash.cloudflare.com/)

2. On the onboarding screen, choose a team name. The team name is a unique, internal identifier for your Zero Trust organization. Users will enter this team name when they enroll their device manually, and it will be the subdomain for your App Launcher (as relevant). Your business name is the typical entry.

3. Complete your onboarding by selecting a subscription plan and entering your payment details. If you chose the **Zero Trust Free plan**, this step is still needed but you will not be charged.

Welcome to Cloudflare Zero Trust! You can now explore a list of one-click actions we have designed to help you kickstart your Zero Trust experience.

## Install the WARP client on your devices

If you want to enable security features such as Browser Isolation, HTTP filtering, AV scanning, and device posture, or connect networks to Cloudflare, here are the next steps you need to take:

1. **Set up a login method.** Configure [One-time PIN](https://developers.cloudflare.com/cloudflare-one/identity/one-time-pin/) or connect a [third-party identity provider](https://developers.cloudflare.com/cloudflare-one/identity/idp-integration/) in Zero Trust. This is the login method your users will utilize when authenticating to add a new device to your Zero Trust setup.

2. **Next, define [device enrollment permissions](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/deployment/device-enrollment/)**. Create device enrollment rules to define which users in your organization should be able to connect devices to your organization's Zero Trust setup. As you create your rule, you will be asked to select which login method you would like users to authenticate with.

3. **Install the [Cloudflare root certificate](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/user-side-certificates/) on your devices.** Advanced security features including HTTP traffic inspection require users to install and trust the Cloudflare root certificate on their machine or device. If you are installing certificates manually on all your devices, these steps will need to be performed on each new device that is to be subject to HTTP filtering.

4. **[Download](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/download-warp/) and deploy the WARP client to your devices**. Choose one of the [different ways](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/deployment/) to deploy the WARP client, depending on what works best for your organization.

5. **Log in to your organization's Cloudflare Zero Trust instance from your devices**. On your device, go to the Settings section in the WARP client and insert your organization's team name.

Your devices are now connected to Cloudflare Zero Trust through the WARP client. You can go to **My Team** > **Devices** to find a list of your enrolled devices, when they were last seen, and the WARP client version they are running.

Next, [enforce security policies](https://developers.cloudflare.com/cloudflare-one/policies/) on your traffic and access requests.
