---
title: Beta Info & Roadmap · Cloudflare Containers docs
description: "Currently, Containers are in beta. There are several changes we
  plan to make prior to GA:"
lastUpdated: 2025-09-22T15:52:17.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/containers/beta-info/
  md: https://developers.cloudflare.com/containers/beta-info/index.md
---

Currently, Containers are in beta. There are several changes we plan to make prior to GA:

## Upcoming Changes and Known Gaps

### Limits

Container limits will be raised in the future. We plan to increase both maximum instance size and maximum number of instances in an account.

See the [Limits documentation](https://developers.cloudflare.com/containers/platform-details/#limits) for more information.

### Autoscaling and load balancing

Currently, Containers are not autoscaled or load balanced. Containers can be scaled manually by calling `get()` on their binding with a unique ID.

We plan to add official support for utilization-based autoscaling and latency-aware load balancing in the future.

See the [Autoscaling documentation](https://developers.cloudflare.com/containers/platform-details/scaling-and-routing) for more information.

### Reduction of log noise

Currently, the `Container` class uses Durable Object alarms to help manage Container shutdown. This results in unnecessary log noise in the Worker logs. You can filter these logs out in the dashboard by adding a Query, but this is not ideal.

We plan to automatically reduce log noise in the future.

### Dashboard Updates

The dashboard will be updated to show:

* links from Workers to their associated Containers

### Co-locating Durable Objects and Containers

Currently, Durable Objects are not co-located with their associated Container. When requesting a container, the Durable Object will find one close to it, but not on the same machine.

We plan to co-locate Durable Objects with their Container in the future.

### More advanced Container placement

We currently prewarm servers across our global network with container images to ensure quick start times. There are times in which you may request a new container and it will be started in a location that farther from the end user than is desired. We are optimizing this process to ensure that this happens as little as possible, but it may still occur.

### Atomic code updates across Workers and Containers

When deploying a Container with `wrangler deploy`, the Worker code will be immediately updated while the Container code will slowly be updated using a rolling deploy.

This means that you must ensure Worker code is backwards compatible with the old Container code.

In the future, Worker code in the Durable Object will only update when associated Container code updates.

## Feedback wanted

There are several areas where we wish to gather feedback from users:

* Do you want to integrate Containers with any other Cloudflare services? If so, which ones and how?
* Do you want more ways to interact with a Container via Workers? If so, how?
* Do you need different mechanisms for routing requests to containers?
* Do you need different mechanisms for scaling containers? (see [scaling documentation](https://developers.cloudflare.com/containers/platform-details/scaling-and-routing) for information on autoscaling plans)

At any point during the Beta, feel free to [give feedback using this form](https://forms.gle/CscdaEGuw5Hb6H2s7).
