---
title: Alternative on-ramps · Cloudflare Learning Paths
description: As discussed in the previous modules, almost everything you do with
  the Cloudflare reverse proxy requires adding a site to Cloudflare. That public
  DNS record (or its subdomains) becomes the domain on which your users access
  your private applications. This method is exceptionally secure and
  transparent; each domain and subdomain has access to the Cloudflare web
  security portfolio, are inherently DDoS protected, and receive an obfuscated
  origin IP. For these reasons, using a public hostname on Cloudflare is the
  recommended method to onboard applications for clientless user
  access.  However, there may be times in which a public DNS record cannot be
  created, or other situations that prevent administrators from using this
  method.
lastUpdated: 2025-09-16T17:43:27.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/clientless-access/alternative-onramps/
  md: https://developers.cloudflare.com/learning-paths/clientless-access/alternative-onramps/index.md
---

As discussed in the previous modules, almost everything you do with the Cloudflare reverse proxy requires [adding a site](https://developers.cloudflare.com/learning-paths/clientless-access/initial-setup/add-site/) to Cloudflare. That public DNS record (or its subdomains) becomes the domain on which your users access your private applications. This method is exceptionally secure and transparent; each domain and subdomain has access to the Cloudflare web security portfolio, are inherently DDoS protected, and receive an obfuscated origin IP. For these reasons, using a [public hostname on Cloudflare](https://developers.cloudflare.com/learning-paths/clientless-access/connect-private-applications/) is the recommended method to onboard applications for clientless user access. However, there may be times in which a public DNS record cannot be created, or other situations that prevent administrators from using this method.

## Objectives

By the end of this module, you will be able to:

* Connect to private web applications using their private hostnames.
