---
title: Use egress policies to deliver consistent egress IPs · Cloudflare
  Learning Paths
description: Egress policies allow you to determine whether your organization's
  traffic egresses via the default Cloudflare IP or via a dedicated egress IP
  assigned to your account.
lastUpdated: 2024-10-07T15:33:31.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/secure-internet-traffic/build-egress-policies/egress-policies/
  md: https://developers.cloudflare.com/learning-paths/secure-internet-traffic/build-egress-policies/egress-policies/index.md
---

Note

Only available on Enterprise plans.

Egress policies allow you to determine whether your organization's traffic egresses via the default Cloudflare IP or via a [dedicated egress IP](https://developers.cloudflare.com/cloudflare-one/policies/gateway/egress-policies/dedicated-egress-ips/) assigned to your account.

To create a new egress policy:

1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **Gateway** > **Egress policies**.

2. Select **Add a policy**.

3. Name the policy.

4. Build a logical expression that defines the traffic you want to control egress for. For example, you can add a policy to configure all traffic destined for a thrid-party network to use a static source IP:

   | Policy name | Selector | Operator | Value | Egress method |
   | - | - | - | - | - |
   | Access third-party provider | Destination IP | is | `198.51.100.158` | Dedicated Cloudflare egress IPs |

   | Primary IPv4 address | IPv6 address |
   | - | - |
   | `203.0.113.88` | `2001:db8::/32` |

5. Select **Create policy**.

For more information, refer to [Egress policies](https://developers.cloudflare.com/cloudflare-one/policies/gateway/egress-policies/).
