---
title: Private Network Load Balancing · Cloudflare Load Balancing docs
description: Use Private Network Load Balancing to load balance traffic between
  servers within a data center or between private applications, and eliminate
  the need for hardware appliances.
lastUpdated: 2025-10-20T16:28:30.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/load-balancing/private-network/
  md: https://developers.cloudflare.com/load-balancing/private-network/index.md
---

Private Network Load Balancing enables you to load balance traffic between servers within a data center ([endpoint steering](https://developers.cloudflare.com/load-balancing/understand-basics/traffic-steering/origin-level-steering/)) and between private applications. This helps you eliminate the need for hardware appliances and facilitates the migration of your infrastructure to the cloud, providing advantages such as elastic scalability and enhanced reliability.

Private Network Load Balancing supports not only public IPs but also virtual IPs and private IPs as endpoint values.

Note

This page assumes a certain level of familiarity with how the Cloudflare Load Balancing solution works. For an introductory overview refer to [Load Balancing components](https://developers.cloudflare.com/load-balancing/understand-basics/load-balancing-components/).

***

## Off-ramps

Off-ramps create a direct and secure way for Cloudflare to connect into your networks that are not publicly available.

Since traffic steering decisions or failover mechanisms rely on the health information of pools and endpoints, being able to input your virtual or private IPs directly as endpoints within your load balancer means you can better leverage existing health monitoring.

### Tunnel

Currently, to be able to connect to private IP origins, Cloudflare load balancers require a [Cloudflare tunnel](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/) with an associated [virtual network (VNet)](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/private-net/cloudflared/tunnel-virtual-networks/).

Once the endpoint and virtual network (VNet) tunnel association is configured, Cloudflare can determine not only the tunnel health but also the health of the corresponding virtual or private IP targets.

Refer to [Set up Private Network Load Balancing with WARP-to-Tunnel](https://developers.cloudflare.com/load-balancing/private-network/warp-to-tunnel/) for a detailed guide.

### Magic WAN

Private Network Load Balancing supports off-ramping traffic for Magic WAN tunnels, such as GRE, IPSec or CNI tunnels. For more information refer to the [Set up Private Network Load Balancing with Magic WAN](https://developers.cloudflare.com/load-balancing/private-network/magic-wan/).

***

## On-ramps

Private Network Load Balancing on-ramps, on the other hand, refer to secure paths between the end-user request and the Cloudflare network. Cloudflare Load Balancing supports traffic from [CDN](https://developers.cloudflare.com/cache/), [Spectrum](https://developers.cloudflare.com/spectrum/), [WARP](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/) and [Magic WAN](https://developers.cloudflare.com/magic-wan/) and forward that traffic to a load balancer, and then egress to an endpoint behind any off-ramp (CDN/CNI/IPSec/GRE/Tunnel). Your traffic can ingress and egress by any on-ramp/off-ramp combination.

Note

When using [Spectrum](https://developers.cloudflare.com/spectrum/) as an on-ramp and [Magic WAN](https://developers.cloudflare.com/load-balancing/private-network/#magic-wan) as an off-ramp the [proxy protocol](https://developers.cloudflare.com/spectrum/how-to/enable-proxy-protocol/) setting in Spectrum is not supported.

***

## Use cases

* **Requests originating from the public Internet and directed to a private/internal service**: You can route requests from the Internet to your internal services on internal IPs - such as accounting or production automation systems - using [Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/).

* **Intelligent traffic routing**: Benefit from failover for your private traffic and have the ability to monitor the health of these IP targets directly, rather than load balancing to a tunnel and only monitoring the health of the tunnel itself.

* **Host applications on non-standard ports**: Easily specify and route traffic to applications hosted on private IP addresses using non-standard ports, allowing greater flexibility in service configuration without requiring changes to existing infrastructure.

* **Public and Private Load Balancers**: Public LBs can direct Internet traffic to private IP addresses, supporting all L7 products like WAF and API Shield. Private LBs direct traffic originating from private networks to private IP addresses and require an on-ramp like WARP or Magic WAN.
