---
title: Get started · Cloudflare Magic Transit docs
description: Before you can begin using Magic Transit, be sure to complete the
  onboarding steps below. Cloudflare can significantly accelerate this timeline
  during active-attack scenarios.
lastUpdated: 2025-05-09T16:24:56.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/magic-transit/get-started/
  md: https://developers.cloudflare.com/magic-transit/get-started/index.md
---

Before you can begin using Magic Transit, be sure to complete the onboarding steps below. Cloudflare can significantly accelerate this timeline during active-attack scenarios.

## Scope your configuration

Magic Transit is not a self-serve product, and as such you need to start by [engaging with our team](https://www.cloudflare.com/network-services/products/magic-transit/) to assess the scope of your needs and a timeline to implement Magic Transit. This is where we assess specific requirements such as your prefix count and how fast you can go through the necessary steps to implement Magic Transit on your network.

## IPs

To use Magic Transit you need to own a publicly routable IP address block with a minimum size of `/24`. If you do not own a `/24` address block, you can use Magic Transit with a Cloudflare-owned IP address. This option is helpful for users who do not meet the `/24` prefix length requirements or who want to protect a smaller network.

To protect your network using a Cloudflare IP address, contact your account manager. After receiving your IP address, you will need to:

* [Create a tunnel](https://developers.cloudflare.com/magic-transit/how-to/configure-tunnel-endpoints/).
* [Set up static routes](https://developers.cloudflare.com/magic-transit/how-to/configure-routes/#configure-static-routes) or [BGP peering](https://developers.cloudflare.com/magic-transit/how-to/configure-routes/#configure-bgp-routes).
* [Configure health checks](https://developers.cloudflare.com/magic-transit/network-health/run-endpoint-health-checks/).
* Confirm [tunnel](https://developers.cloudflare.com/magic-transit/network-health/update-tunnel-health-checks-frequency/) and endpoint health checks were properly configured.
* Update your infrastructure at your own pace to use the allocated Cloudflare IPs.

When you use a Cloudflare-owned IP space, you do not need a Letter of Agency (LOA). When using Cloudflare-leased IPs, [Magic Transit Egress](https://developers.cloudflare.com/magic-transit/reference/egress/) is automatically enabled — that is, your egress traffic will also be destined to Cloudflare instead of the Internet. Because of this, you will need to set up policy-based routing on your end to make sure that return traffic is properly routed.

## Verify router compatibility

Magic Transit relies on anycast tunnels to transmit packets from Cloudflare's global network to your origin network.

The routers at your tunnel endpoints must meet the following requirements to ensure compatibility with Magic Transit.

* Support GRE tunnels (or IPsec if GRE is not available).
* Allow configuration of at least one tunnel per Internet service provider (ISP).
* Support maximum segment size (MSS) clamping.
* Support asymmetric traffic flow (for ingress-only Magic Transit).

## Draft Letter of Agency

Draft a [Letter of Agency (LOA)](https://developers.cloudflare.com/byoip/concepts/loa/) — sometimes referred to as a Letter of Authorization — that identifies the prefixes you want to advertise and gives Cloudflare permission to announce them. The LOA is required by Cloudflare's transit providers so they can accept the routes Cloudflare advertises on your behalf.

If you are an Internet service provider (ISP) and advertising prefixes on behalf of a customer, an LOA is required for the ISP and for the customer.

If you are using a [Cloudflare IP address](#ips), you do not need to submit an LOA.

Note

The LOA must be a PDF. Transit providers may reject the LOA if it is a JPG or PNG.

### Example of a Letter of Agency

```txt
[COMPANY LETTERHEAD]


LETTER OF AGENCY ("LOA")


[DATE]




To whom it may concern:


[COMPANY NAME] (the "Company") authorizes Cloudflare, Inc. with AS13335 to advertise the following IP address blocks / originating ASNs:


- - - - - - - - - - - - - - - - - - -
[Subnet & Originating ASN]
[Subnet & Originating ASN]
[Subnet & Originating ASN]
- - - - - - - - - - - - - - - - - - -


As a representative of the Company that is the owner of the aforementioned IP address blocks / originating ASNs, I hereby declare that I am authorized to sign this LOA on the Company’s behalf.


Should you have any questions please email me at [E-MAIL ADDRESS], or call: [TELEPHONE NUMBER]


Regards,




[SIGNATURE]




[NAME TYPED]
[TITLE]
[COMPANY NAME]
[COMPANY ADDRESS]
[COMPANY STAMP]
```

## Verify IRR entries

Verify that your Internet Routing Registry (IRR) entries match your corresponding origin autonomous system numbers (ASNs) to ensure Magic Transit routes traffic to the correct autonomous systems (AS). For guidance, refer to [Verify IRR entries](https://developers.cloudflare.com/byoip/concepts/irr-entries/best-practices/#verify-an-irr-entry).

If you are using a [Cloudflare IP](#ips), you do not need to verify your IRR entries.

### Optional: RPKI check for prefix validation

You can also use the Resource Public Key Infrastructure (RPKI) as an additional option to validate your prefixes. RPKI is a [security framework method](https://blog.cloudflare.com/rpki/) that associates a route with an autonomous system. It uses cryptography to validate the information before being passed onto the routers.

If you operate a network (ISP, cloud provider, enterprise, and others.), using RPKI ensures that your IP prefixes are correctly recognized. This prevents service disruptions and protects your brand's reputation. Without RPKI, attackers could announce your IP space, misdirect your traffic, and potentially harm your business.

To check your prefixes, you can use [Cloudflare's RPKI Portal](https://rpki.cloudflare.com/?view=validator).

## Set maximum segment size

Before enabling Magic Transit, you must make sure that you set up the maximum segment size on your network. Cloudflare Magic Transit uses tunnels to deliver [packets](https://www.cloudflare.com/learning/network-layer/what-is-a-packet/) from our global network to your data centers. Cloudflare encapsulates these packets adding new headers. You must account for the space consumed by these headers when configuring the maximum transmission unit (MTU) and maximum segment size (MSS) values for your network.

### MSS clamping recommendations

#### GRE tunnels as off-ramp

The MSS value depends on how your network is set up.

* **Magic Transit ingress-only traffic (DSR):**

  * **On your edge router transit ports**: Apply a TCP MSS clamp with a maximum of 1,436 bytes.
  * **On any IPsec/GRE tunnels with third parties on your Magic Transit prefix**: Apply the MSS clamp on the internal tunnel interface (most likely on a separate firewall behind the GRE-terminating router) to reduce the current value by 24 bytes.

* **For Magic Transit ingress + egress traffic:**

  * **On the Magic Transit GRE tunnel internal interface**: Meaning where the Magit Transit egress traffic will traverse. This may be done automatically once the tunnel is configured but it depends on your devices. The TCP MSS clamp should be 1,436 bytes maximum.
  * **On any IPsec/GRE tunnels with third parties on your Magic Transit prefix**: On the internal tunnel interface (most likely on a separate firewall behind the GRE-terminating router) to reduce its current value by 24 bytes.

#### IPsec tunnels

For IPsec tunnels, the value you need to specify depends on how your network is set up. The MSS clamping value will be lower than for GRE tunnels, however, since the physical interface will see IPsec-encrypted [packets](https://www.cloudflare.com/learning/network-layer/what-is-a-packet/), not TCP packets, and MSS clamping will not apply to those.

* **Magic Transit ingress-only traffic (DSR):**

  * **On your edge router transit ports**: TCP MSS clamp should be 1,436 bytes maximum.
  * **On any IPsec/GRE tunnels with third parties on your Magic Transit prefix**: on the internal tunnel interface (most likely on a separate firewall behind the GRE-terminating router) to reduce its current value by 140 bytes.

* **Magic Transit ingress + egress traffic:**

  * **On your edge router**: Apply this on your Magic Transit IPsec tunnel internal interface (that is, where the Magic Transit egress traffic will traverse). This may be done automatically once the tunnel is configured but it depends on your devices. TCP MSS clamp should be 1,360 bytes maximum.
  * **On any IPsec/GRE tunnels with third parties on your Magic Transit prefix**: on the internal tunnel interface (most likely on a separate firewall behind the IPsec-terminating device in your premises) to reduce its current value by 140 bytes.

Important

Refer to your device documentation to check if it sets IPsec MSS clamping automatically. If that is not the case and you are using IPsec inside GRE, you have to set MSS clamp manually.

Refer to [Maximum transmission unit and maximum segment size](https://developers.cloudflare.com/magic-transit/reference/mtu-mss/) for more details.

#### Clear Do not fragment (DF)

If you are unable to set the MSS on your physical interfaces to a value lower than 1500 bytes, you can choose to clear the `do not fragment` bit in the IP header. When this option is enabled, Cloudflare fragments [packets](https://www.cloudflare.com/learning/network-layer/what-is-a-packet/) greater than 1500 bytes, and the packets are reassembled on your infrastructure after decapsulation. In most environments, enabling this option does not have a significant impact on traffic throughput.

To enable this option for your network, contact your account team.

Refer to [Maximum transmission unit and maximum segment size](https://developers.cloudflare.com/magic-transit/reference/mtu-mss/) for more details.

## Follow router vendor guidelines

Instructions to adjust MSS by applying MSS clamps vary depending on the vendor of your router.

The following table lists several commonly used router vendors with links to MSS clamping instructions:

| Router device | URL |
| - | - |
| Cisco | [TCP IP Adjust MSS](https://www.cisco.com/en/US/docs/ios-xml/ios/ipapp/command/ip_tcp_adjust-mss_through_ip_wccp_web-cache_accelerated.html#GUID-68044D35-A53E-42C1-A7AB-9236333DA8C4) |
| Juniper | [TCP MSS - Edit System](https://www.juniper.net/documentation/en_US/junos/topics/reference/configuration-statement/tcp-mss-edit-system.html) |

## Configure tunnels

[Configure the tunnels](https://developers.cloudflare.com/magic-transit/how-to/configure-tunnel-endpoints/) on both the Cloudflare side and your router side to connect to your origin infrastructure.

## Configure static routes or BGP peering

Configure [static routes](https://developers.cloudflare.com/magic-transit/how-to/configure-routes/#configure-static-routes) or [BGP peering](https://developers.cloudflare.com/magic-transit/how-to/configure-routes/#configure-bgp-routes) to route traffic from Cloudflare's global network to your locations.

## Run pre-flight checks

After setting up your tunnels and routes, Cloudflare validates:

* Tunnel connectivity
* Tunnel and endpoint [health checks](https://developers.cloudflare.com/magic-transit/reference/tunnel-health-checks/#tunnel-health-checks)
* Letter of Agency (LOA)
* Internet Routing Registry (IRR)
* Maximum segment size (MSS) configurations

Configurations for Cloudflare global network are applied and take around one day to rollout.

## Advertise prefixes

Once pre-flight checks are completed, Cloudflare will unlock your prefixes for you to [advertise via the dashboard, API or BGP](https://developers.cloudflare.com/magic-transit/how-to/advertise-prefixes/) at a time of your choosing. Refer to [Dynamic advertisement best practices](https://developers.cloudflare.com/byoip/concepts/dynamic-advertisement/best-practices/) to learn more about advertising prefixes.

If you are using a Cloudflare IP, you do not need to advertise your prefixes.

Warning

You must [put the appropriate MSS clamps](#set-maximum-segment-size) in place before [routing](https://www.cloudflare.com/learning/network-layer/what-is-routing/) changes are made. Failure to apply an MSS clamp can result in dropped packets and hard-to-debug connectivity issues.

Also, when using [Cloudflare Network Interconnect](https://developers.cloudflare.com/magic-transit/network-interconnect/) with Magic Transit you must set the following MSS clamp sizes to accommodate additional overhead:

* GRE tunnels over Classic CNI: 1476 bytes
* Direct CNI / Classic CNI with a maximum transmission unit (MTU) size of 1500 bytes handoff does not require an MSS clamp.

MSS clamps are used to backhaul data from the data center where traffic is ingested (close to the end user) to the facility with the CNI link.
