---
title: Configure routes · Cloudflare Magic WAN docs
description: Magic WAN uses a static configuration to route your traffic through
  anycast tunnels from Cloudflare's global network to your locations. If you are
  connected through Direct CNI you also have access to BGP peering.  Learn how
  to configure routing.
lastUpdated: 2025-10-17T16:00:12.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/magic-wan/configuration/manually/how-to/configure-routes/
  md: https://developers.cloudflare.com/magic-wan/configuration/manually/how-to/configure-routes/index.md
---

Magic Networking uses a routing table to steer your traffic via next-hop from Cloudflare's global network to your connected networks. Entries can be added to the Magic routing table via static route configuration or via routes learned through BGP peering (only available over Direct CNI).

Refer to [Traffic Steering](https://developers.cloudflare.com/magic-wan/reference/traffic-steering/) for more information about all the technical aspects related to:

* Routes' priorities and weights
* Regional scoping of traffic to reduce latency
* BGP peering

## Configure static routes

The following IPv4 address ranges are allowed in the Magic Routing table:

* [RFC 1918](https://datatracker.ietf.org/doc/html/rfc1918) address space, specifically `10.0.0.0/8`, `172.16.0.0/12`, and `192.168.0.0/16`.

When using Magic WAN and Cloudflare Tunnel together, remember to consider the IP ranges utilized in the static routes of Cloudflare Tunnel when selecting static routes for Magic WAN. For more information, refer to [Cloudflare Tunnel](https://developers.cloudflare.com/magic-wan/zero-trust/cloudflare-tunnel/).

For prefixes outside RFC 1918 contact your Cloudflare customer service manager.

### Create a static route

* Dashboard

  1. In the Cloudflare dashboard, go to Magic WAN's **Configuration** page.

     [Go to **Configuration**](https://dash.cloudflare.com/?to=/:account/magic-wan/configuration)

  2. From the **Routes** tab, select **Create** to add a new route.

  3. Enter a descriptive name for your route in **Description**.

  4. In **Prefix**, enter your range of IP addresses. For example, `10.10.10.100/24`.

  5. In **Tunnel/Next hop** select which tunnel you want your route to go through. Choose from the tunnels you have created in [Configure tunnel endpoints](https://developers.cloudflare.com/magic-wan/configuration/manually/how-to/configure-tunnel-endpoints/).

  6. Choose the **Priority** for your route. Lower numbers have higher priorities.

     Note

     Cloudflare routing applies longest-prefix match. A more specific static route (like `/30`) will always be preferred over a less specific one (like `/29`), regardless of tunnel priority — unless the more specific route is removed.

     Have this in mind when configuring priorities for your routes. Refer to [Route prioritization](https://developers.cloudflare.com/magic-wan/reference/traffic-steering/#route-prioritization) for more information.

  7. (Optional) Choose a **Weight** for your route. Refer to [Set priority and weights for static routes](https://developers.cloudflare.com/magic-wan/reference/traffic-steering/#set-priority-and-weights-for-static-routes) for examples.

  8. (Optional) If you need to scope your route to a specific region, you can do it in **Region code**.

  9. (Optional) We highly recommend testing your route before adding it by selecting **Test routes**.

  10. Select **Add routes** when you are done.

* API

  Note

  You will need your [account ID](https://developers.cloudflare.com/fundamentals/account/find-account-and-zone-ids/) and [API Key](https://developers.cloudflare.com/fundamentals/api/get-started/keys/#view-your-global-api-key) to use the API.

  Create a `POST` request [using the API](https://developers.cloudflare.com/api/resources/magic_transit/subresources/routes/methods/create/) to create one or more static routes.

  Example:

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Magic WAN Write`
  * `Magic Transit Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/magic/routes" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "nexthop": "<IP_NEXT_HOP>",
      "prefix": "<YOUR_IP_PREFIX>",
      "priority": 0,
      "id": "023e105f4ecef8ad9ca31a8372d0c353",
      "description": "<ROUTE_DESCRIPTION>",
      "scope": {
          "colo_names": [
              "den01"
          ],
          "colo_regions": [
              "APAC"
          ]
      },
      "weight": 0
    }'
  ```

  ```json
  {
    "errors": [
      {
        "code": 1000,
        "message": "message"
      }
    ],
    "messages": [
      {
        "code": 1000,
        "message": "message"
      }
    ],
    "result": {
      "routes": [
        {
          "nexthop": "203.0.113.1",
          "prefix": "192.0.2.0/24",
          "priority": 0,
          "id": "023e105f4ecef8ad9ca31a8372d0c353",
          "description": "New route for new prefix 203.0.113.1",
          "scope": {
            "colo_names": [
              "den01"
            ],
            "colo_regions": [
              "APAC"
            ]
          },
          "weight": 0
        }
      ]
    },
    "success": true
  }
  ```

### Edit a static route

* Dashboard

  1. In **Routes**, select **Edit** next to the route you want to modify.
  2. Enter the updated route information.
  3. (Optional) We highly recommend testing your route before adding it by selecting **Test routes**.
  4. Select **Edit routes** to save the new information when you are done.

* API

  Note

  You will need your [account ID](https://developers.cloudflare.com/fundamentals/account/find-account-and-zone-ids/) and [API Key](https://developers.cloudflare.com/fundamentals/api/get-started/keys/#view-your-global-api-key) to use the API.

  Create a `PUT` request [using the API](https://developers.cloudflare.com/api/resources/magic_transit/subresources/routes/methods/update/) to update one or more static routes.

  Example:

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Magic WAN Write`
  * `Magic Transit Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/magic/routes/$ROUTE_ID" \
    --request PUT \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "nexthop": "<IP_NEXT_HOP>",
      "prefix": "<YOUR_IP_PREFIX>",
      "priority": 0,
      "id": "023e105f4ecef8ad9ca31a8372d0c353",
      "description": "<ROUTE_DESCRIPTION>",
      "scope": {
          "colo_names": [
              "den01"
          ],
          "colo_regions": [
              "APAC"
          ]
      },
      "weight": 0
    }'
  ```

  ```json
  {
    "errors": [
      {
        "code": 1000,
        "message": "message"
      }
    ],
    "messages": [
      {
        "code": 1000,
        "message": "message"
      }
    ],
    "result": {
      "modified": true,
      "modified_route": {
        "nexthop": "203.0.113.1",
        "prefix": "192.0.2.0/24",
        "priority": 0,
        "id": "023e105f4ecef8ad9ca31a8372d0c353",
        "description": "New route for new prefix 203.0.113.1",
        "scope": {
          "colo_names": [
            "den01"
          ],
          "colo_regions": [
            "APAC"
          ]
        },
        "weight": 0
      }
    },
    "success": true
  }
  ```

### Delete static route

* Dashboard

  1. In **Routes**, locate the static route you want to modify and select **Delete**.
  2. Confirm the action by selecting the checkbox and select **Delete**.

* API

  Note

  You will need your [account ID](https://developers.cloudflare.com/fundamentals/account/find-account-and-zone-ids/) and [API Key](https://developers.cloudflare.com/fundamentals/api/get-started/keys/#view-your-global-api-key) to use the API.

  Create a `DELETE` request [using the API](https://developers.cloudflare.com/api/resources/magic_transit/subresources/routes/methods/delete/) to delete a static route.

  Example:

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Magic WAN Write`
  * `Magic Transit Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/magic/routes/$ROUTE_ID" \
    --request DELETE \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN"
  ```

  ```json
  {
    "errors": [
      {
        "code": 1000,
        "message": "message"
      }
    ],
    "messages": [
      {
        "code": 1000,
        "message": "message"
      }
    ],
    "result": {
      "deleted": true,
      "deleted_route": {
        "nexthop": "203.0.113.1",
        "prefix": "192.0.2.0/24",
        "priority": 0,
        "id": "023e105f4ecef8ad9ca31a8372d0c353",
        "description": "New route for new prefix 203.0.113.1",
        "scope": {
          "colo_names": [
            "den01"
          ],
          "colo_regions": [
            "APAC"
          ]
        },
        "weight": 0
      }
    },
    "success": true
  }
  ```

## Configure BGP routes

BGP peering is available when using a [Direct CNI](https://developers.cloudflare.com/network-interconnect/) as an on-ramp.

### Choose an ASN for BGP peering

The Magic routing table is managed by the customer, who can select both the Cloudflare-side ASN and the ASN for their customer device. The customer device ASN can be 2-byte or 4-byte.

By default, each BGP peering session will use the same Cloudflare-side ASN to represent peering with the Magic WAN routing table. This ASN is called the **CF Account ASN** and is set to `13335`. This can be configured to a private 2-byte ASN (for example, any values between `64512` and `65534`). To set this ASN:

1. In the Cloudflare dashboard, go to Magic WAN's **Configuration** page.

   [Go to **Configuration**](https://dash.cloudflare.com/?to=/:account/magic-wan/configuration)

2. Go to **BGP configuration**.

3. In **CF Account ASN**, enter Cloudflare's ASN.

4. Select **Update**.

Magic WAN customers should also be aware of the following:

* The customer chooses their device ASN, which must be different to the Cloudflare-side ASN.

* The Cloudflare side ASN will be included in the `AS_PATH` of announced routes to any BGP enabled interconnect.

* The customer-announced `AS_PATH` is transitive between interconnects — meaning the origin (customer) ASN is visible in the `AS_PATH` of routes received from Cloudflare via BGP. Due to default BGP loop prevention mechanisms, a router will reject any route that contains its own ASN in the `AS_PATH`. For example, if two Magic WAN-connected sites both use `ASN 65000`, site A will not accept routes from site B, and vice versa, because each site sees its own ASN in the advertised `AS_PATH`.\
  To enable routing between private networks over Magic WAN, you should either:

  * Assign a unique ASN to each site/network, or
  * Configure your edge CPE to accept BGP routes that include its own ASN in the `AS_PATH`.

### Set up BGP peering

Warning

BGP peering is only available to Magic WAN customers with Direct CNI as an on-ramp. If your network is set up with GRE or IPsec tunnels, you cannot use BGP peering.

You need to configure two ASNs:

* The Cloudflare [account-scoped ASN](#choose-an-asn-for-bgp-peering) named **CF Account ASN**.
* One ASN for each interconnect you want to configure with BGP.

If you already have set up your Cloudflare account ASN, you can skip steps two and three below.

1. In the Cloudflare dashboard, go to Magic WAN's **Configuration** page.

   [Go to **Configuration**](https://dash.cloudflare.com/?to=/:account/magic-wan/configuration)

2. Go to **BGP configuration**.

3. In **CF Account ASN**, enter Cloudflare's ASN.

4. Go to **Interconnects**.

5. Find the Direct CNI interconnect you want to configure with BGP > select the **three dots** next to it > **Configure BGP**.

6. In **Customer device ASN**, enter the ASN for your network.

   Note

   Multiple interconnects with the same ASN will not exchange routes if standard BGP loop prevention is enabled. Consider using a different ASN per session, or enabling duplicate ASNs (like Cisco's `allowas-in` feature) to exchange routes between networks.

7. In **MD5 key**, you can optionally enter the key for your network. Note that this is meant to prevent accidental misconfigurations, and is not a security mechanism.

8. (Optional) In **Advertised prefix list**, input the additional prefixes automatically assigned by Cloudflare during the creation of the CNI interconnect, to advertise alongside your existing routes. Leave blank if you do not want to advertise extra routes.\
   Typical prefixes to configure here include:

   * A route to `0.0.0.0/0`, the default route — to attract all Internet-bound traffic if using Magic WAN with Gateway.
   * A route to `100.96.0.0/12`, the portion of CGNAT space [used by default with WARP clients](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/private-net/warp-connector/user-to-site/#add-route-to-router).

9. Select **Save**.

## Next steps

Now that you have configured your tunnels and routes, the next step is to create a site.

Sites represent the local network of a data center, office, or other physical location, and combine all on-ramps available there. Sites also allow you to check, at a glance, the state of your on-ramps and set up health alert settings so that you get notified when there are issues with the site's on-ramps.

Refer to [Set up a site](https://developers.cloudflare.com/magic-wan/configuration/common-settings/sites/) for more information.
