---
title: Remove query strings before sending request to origin · Cloudflare Rules docs
description: Remove certain query strings from a request before passing to the origin.
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
tags: Request modification
source_url:
  html: https://developers.cloudflare.com/rules/snippets/examples/remove-query-strings/
  md: https://developers.cloudflare.com/rules/snippets/examples/remove-query-strings/index.md
---

```js
export default {
  async fetch(request) {
    // Define the query strings you want to remove
    const queryStringsToRemove = ["utm_source", "utm_medium", "utm_campaign"];


    // Get the URL from the request
    const url = new URL(request.url);


    // Remove the specified query strings
    queryStringsToRemove.forEach((query) => {
      url.searchParams.delete(query);
    });


    // Create a new request with the modified URL
    const modifiedRequest = new Request(url, request);


    // Pass the modified request to the origin
    const response = await fetch(modifiedRequest);


    return response;
  },
};
```
