---
title: Full (strict) - SSL/TLS encryption modes · Cloudflare SSL/TLS docs
description: Similar to Full Mode, but with added validation of the origin
  server’s certificate, which can be issued by a public CA like Let’s Encrypt or
  by Cloudflare Origin CA.
lastUpdated: 2025-08-20T18:47:44.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ssl/origin-configuration/ssl-modes/full-strict/
  md: https://developers.cloudflare.com/ssl/origin-configuration/ssl-modes/full-strict/index.md
---

When you set your encryption mode to **Full (strict)**, Cloudflare does everything in [Full mode](https://developers.cloudflare.com/ssl/origin-configuration/ssl-modes/full/) but also enforces more stringent requirements for origin certificates.

```mermaid
flowchart LR
    accTitle: Full - Strict SSL/TLS Encryption
    accDescr: With an encryption mode of Full (strict), your application encrypts traffic going to and coming from Cloudflare.
    A[Browser] <--Encrypted--> B((Cloudflare))<--Encrypted--> C[("Origin server (verified) #9989;")]
```

## Use when

For the best security, choose **Full (strict)** mode whenever possible (unless you are an [Enterprise customer](https://developers.cloudflare.com/ssl/origin-configuration/ssl-modes/ssl-only-origin-pull/)).

Your origin needs to be able to support an SSL certificate that is:

* Unexpired, meaning the certificate presents `notBeforeDate < now() < notAfterDate`.
* Issued by a [publicly trusted certificate authority](https://github.com/cloudflare/cfssl_trust) or [Cloudflare’s Origin CA](https://developers.cloudflare.com/ssl/origin-configuration/origin-ca/).
* Contains a Common Name (CN) or Subject Alternative Name (SAN) that matches the requested or target hostname.

Note

In addition to **Full (strict)** encryption, you can also set up [Authenticated Origin Pulls](https://developers.cloudflare.com/ssl/origin-configuration/authenticated-origin-pull/) to ensure all requests to your origin are evaluated before receiving a response.

## Required setup

### Prerequisites

Before enabling **Full (strict)** mode, make sure your origin:

* Allows HTTPS connections on port `443`.
* Presents a certificate matching the requirements above.

Otherwise, your visitors may experience a [526 error](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-5xx-errors/error-526/).

### Process

* Dashboard

  To change your encryption mode in the dashboard:

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com) and select your account and domain.
  2. Go to **SSL/TLS**.
  3. Choose an encryption mode.

* API

  To adjust your encryption mode with the API, send a [`PATCH`](https://developers.cloudflare.com/api/resources/zones/subresources/settings/methods/edit/) request with `ssl` as the setting name in the URI path, and the `value` parameter set to your desired setting (`off`, `flexible`, `full`, `strict`, or `origin_pull`).

## Limitations

Depending on your origin configuration, you may have to adjust settings to avoid [Mixed Content errors](https://developers.cloudflare.com/ssl/troubleshooting/mixed-content-errors/) or [redirect loops](https://developers.cloudflare.com/ssl/troubleshooting/too-many-redirects/).
