---
title: Error 417 · Cloudflare Support docs
description: The 417 Expectation Failed status code indicates that the server
  could not meet the requirements specified in the Expect header of the client's
  request.
lastUpdated: 2025-05-21T17:09:12.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/4xx-client-error/error-417/
  md: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/4xx-client-error/error-417/index.md
---

## 417 Expectation Failed

The `417 Expectation Failed` status code indicates that the server could not meet the requirements specified in the `Expect` header of the client's request.

For more details, refer to [RFC 7231](https://tools.ietf.org/html/rfc7231).

### Common use cases

Some clients use the `Expect` header, such as `Expect: 100-continue`, to verify if the server is ready to receive a large payload, and if the server cannot fulfill this expectation, it returns a 417 response. Similarly, a server may reject a request with this error if the client includes an `Expect` header with unsupported or invalid values.

### Cloudflare-specific information

Cloudflare typically forwards this response from the origin server if it encounters an issue related to unsupported or unfulfilled `Expect` headers in the client's request.
