---
title: Error 521 · Cloudflare Support docs
description: Error 521 occurs when the origin web server refuses connections
  from Cloudflare. Security solutions at your origin may block legitimate
  connections from certain Cloudflare IP addresses.
lastUpdated: 2025-04-29T14:48:33.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-5xx-errors/error-521/
  md: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-5xx-errors/error-521/index.md
---

## Error 521: web server is down

Error `521` occurs when the origin web server refuses connections from Cloudflare. Security solutions at your origin may block legitimate connections from certain [Cloudflare IP addresses](https://www.cloudflare.com/ips).

### Common causes

The two most common causes of `521` errors are:

* Offlined origin web server application.
* Blocked Cloudflare requests.

### Resolution

Contact your hosting provider or site administrator and share the necessary [error details](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-5xx-errors/#required-error-details-for-hosting-provider) to assist in troubleshooting these common causes:

* Ensure your origin web server is responsive.
* Review origin web server error logs to identify web server application crashes or outages.
* Confirm [Cloudflare IP addresses](https://www.cloudflare.com/ips) are not blocked or rate limited.
* Allow all [Cloudflare IP ranges](https://www.cloudflare.com/ips) in your origin web server's firewall or other security software.
* Confirm that — if you have your **SSL/TLS mode** set to **Full** or **Full (Strict**) — your origin supports HTTPS and/or you have installed a [Cloudflare Origin Certificate](https://developers.cloudflare.com/ssl/origin-configuration/origin-ca) or a certificate matching the [requirements for these modes](https://developers.cloudflare.com/ssl/origin-configuration/ssl-modes/#custom-ssltls).
* Find additional troubleshooting information on the [Cloudflare Community](https://community.cloudflare.com/t/community-tip-fixing-error-521-web-server-is-down/42461).
