---
title: Onboard your domain to Cloudflare | Cloudflare Docs
description: Learn how Cloudflare secures and accelerates your website using its
  global network and reverse proxy technology. In this video, we explain how
  connecting your domain to Cloudflare protects your origin server, enhances
  performance, and keeps your site online—even during attacks. You'll see how
  DNS, nameservers, and proxy status work together to route and safeguard
  traffic. Whether you're self-hosting or using serverless platforms like
  Cloudflare Workers, this guide helps you understand the onboarding process and
  why Cloudflare is essential for modern web infrastructure.
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/videos/onboard-domain-cf/
  md: https://developers.cloudflare.com/videos/onboard-domain-cf/index.md
---

Learn how Cloudflare secures and accelerates your website using its global network and reverse proxy technology. In this video, we explain how connecting your domain to Cloudflare protects your origin server, enhances performance, and keeps your site online—even during attacks. You'll see how DNS, nameservers, and proxy status work together to route and safeguard traffic. Whether you're self-hosting or using serverless platforms like Cloudflare Workers, this guide helps you understand the onboarding process and why Cloudflare is essential for modern web infrastructure.



Transcript

Cloudflare operates a global network that makes your online presence faster and protect

it from cyber attacks.

When you connect a website or app to Cloudflare,

we act as both the authoritative DNS provider and a reverse proxy that sits between your

visitors and your origin servers.

When a visitor or an attacker tries to reach your website,

those requests are first routed to the Cloudflare network instead of your origin

server. Cloudflare processes those requests, mitigating malicious traffic while speeding

up legitimate traffic.

Our services are customizable to give you granular control over your traffic.

You can write rules to cache, load, balance and redirect requests,

modify headers, execute code, and more.

Many of our services are on by default, such as DDoS protection and caching,

so your traffic will automatically be safer and faster.

To make this possible, you need to onboard your domain to

Cloudflare. The most common way to onboard your domain is to update your DNS name

servers to the Cloudflare name servers we provide you,

which makes Cloudflare your authoritative DNS provider.

You do this at the provider you purchase your domain name from,

such as a registrar. If you need a new domain,

you can purchase one at cost from the Cloudflare registrar,

which is automatically configured to use our name servers.

Let's review the basics of name servers and DNS.

A name server is a service operated by your authoritative DNS provider that acts as a

source of truth for your domain's DNS records.

Dns records map a human readable hostname, such as example.com,

to machine readable IP addresses or data.

The IP address listed in a DNS record identifies where your origin server is

hosted. These DNS records tell your authoritative DNS provider how to respond to

DNS queries for your domain.

So altogether, DNS allows internet browsers such as Google Chrome to find the correct

content. Then the browser can make HTTP requests to load the content for your

visitors. If you're not using a reverse proxy such as Cloudflare.

The browser makes HTTP requests directly to the IP address of your origin server.

This is not secure because your origin is exposed to the internet without protection.

When Cloudflare is in front of your origin, we act as both your authoritative DNS

provider and a reverse proxy for your HTTP requests.

We respond to DNS queries with Cloudflare IP addresses,

which makes your HTTP traffic go through Cloudflare instead of directly to your

origin. This process is called reverse Proxying,

which allows us to hide and therefore protect your origin server.

Furthermore, we highly recommend blocking traffic that doesn't come through Cloudflare

by configuring your origins firewall to only allow Cloudflare IP addresses or using

Cloudflare Tunnel. You can identify which traffic is proxy in the DNS records table in

the Cloudflare dashboard.

If the proxy status is set to proxy, requests for those hostname will flow through

the Cloudflare network.

This will start happening once you update your nameservers.

If the status is as DNS only.

Requests for those hostnames will only use Cloudflare for DNS resolution.

Let's follow an HTTP request as it gets processed by Cloudflare when someone visits

or tries to attack your website or app.

That request will be routed to the Cloudflare data center that's closest to that visitor.

If a request is from a legitimate user, we check if it's for a resource that's in the

Cloudflare cache. If we don't have it cached,

we proxy the request to your origin server.

We then cache the origins response.

So the next time Cloudflare sees a request for the same resource,

we can deliver it straight away.

We block suspicious requests from reaching your origin,

only allowing legitimate users and speeding up their experience.

So you will always have the most up to date security posture,

including protection from Sierra de vulnerabilities,

advanced DDoS attacks, and more.

Cloudflare is an extension of your infrastructure,

keeping your site safe and highly available.

Get started with onboarding your domain today.
