---
title: Evaluation example · Cloudflare Web Application Firewall (WAF) docs
description: "The following example calculates the OWASP request threat score
  for an incoming request. The OWASP managed ruleset configuration is the
  following:"
lastUpdated: 2025-07-09T14:24:57.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/managed-rules/reference/owasp-core-ruleset/example/
  md: https://developers.cloudflare.com/waf/managed-rules/reference/owasp-core-ruleset/example/index.md
---

The following example calculates the OWASP request threat score for an incoming request. The OWASP managed ruleset configuration is the following:

* OWASP Anomaly Score Threshold: *High - 25 and higher*
* OWASP Paranoia Level: *PL3*
* OWASP Action: *Managed Challenge*

This table shows the progress of the OWASP ruleset evaluation:

| Rule ID | Paranoia level | Rule matched? | Rule score | Cumulative threat score |
| - | - | - | - | - |
| – | – | – | – | 0 |
| `...1813a269` | PL3 | Yes | +5 | 5 |
| `...ccc02be6` | PL3 | No | – | 5 |
| `...96bfe867` | PL2 | Yes | +5 | 10 |
| `...48b74690` | PL1 | Yes | +5 | 15 |
| `...3297003f` | PL2 | Yes | +3 | 18 |
| `...317f28e1` | PL1 | No | – | 18 |
| `...682bb405` | PL2 | Yes | +5 | 23 |
| `...56bb8946` | PL2 | No | – | 23 |
| `...e5f94216` | PL3 | Yes | +3 | 26 |
| (...) | (...) | (...) | (...) | (...) |
| `...f3b37cb1` | PL4 | (not evaluated) | – | 26 |

Final request threat score: `26`

Since `26` >= `25` — that is, the threat score is greater than the configured score threshold — Cloudflare will apply the configured action (*Managed Challenge*). If you had configured a score threshold of *Medium - 40 and higher*, Cloudflare would not apply the action, since the request threat score would be lower than the score threshold (`26` < `40`).

[**Sampled logs** in Security Events](https://developers.cloudflare.com/waf/analytics/security-events/#sampled-logs) would display the following details for the example incoming request handled by the OWASP Core Ruleset:

![Event log for example incoming request mitigated by the OWASP Core Ruleset](https://developers.cloudflare.com/_astro/owasp-example-event-log.B3Lc0T9C_bD8zK.webp)

In sampled logs, the rule associated with requests mitigated by the Cloudflare OWASP Core Ruleset is the last rule in this managed ruleset: `949110: Inbound Anomaly Score Exceeded`, with rule ID 6179ae15870a4bb7b2d480d4843b323c . To get the scores of individual rules contributing to the final request threat score, expand **Additional logs** in the event details.
