---
title: Fetch HTML · Cloudflare Workers docs
description: Send a request to a remote server, read HTML from the response, and
  serve that HTML.
lastUpdated: 2025-08-20T18:47:44.000Z
chatbotDeprioritize: false
tags: JavaScript,TypeScript,Python
source_url:
  html: https://developers.cloudflare.com/workers/examples/fetch-html/
  md: https://developers.cloudflare.com/workers/examples/fetch-html/index.md
---

If you want to get started quickly, click on the button below.

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/docs-examples/tree/main/workers/fetch-html)

This creates a repository in your GitHub account and deploys the application to Cloudflare Workers.

* JavaScript

  ```js
  export default {
    async fetch(request) {
      /**
       * Replace `remote` with the host you wish to send requests to
       */
      const remote = "https://example.com";


      return await fetch(remote, request);
    },
  };
  ```

  [Run Worker in Playground](https://workers.cloudflare.com/playground#LYVwNgLglgDghgJwgegGYHsHALQBM4RwDcABAEbogB2+CAngLzbPYZb6HbW5QDGU2AAwBGAGwBmEQA4ArAHY5oqQC4WLNsA5wuNPgJETp8xVICwAKADC6KhACmt7ABEoAZxjpXUaDeUkNeATEJFRwwHYMAERQNHYAHgB0AFaukaSoUGAOYRHRsYkpkRbWtg4Q2AAqdDB2fnAwMGB8BFA2yElwAG5wrrwIsBAA1MDouOB2FhbxHkgkuHaocOAQJADe5iQkPXRUvP52ELwAFgAUCHYAjiB2rhAAlGsbmyTIAFSvT8+vJABKdo1wXh2EgAA3OI3sIJIAHdvEcSBAjsCjp4VnRKDC3PCIOgSK4HLgSOcrjcIK4EehPptXsgqbwbLciXYIcCGCRIkcIBAYK5lMhkPEwo07Al6cA0uYqecICAEFQttC4N59odTuD0PYADRMkm3O5EJ4AX015kNRAsamYGi0Oh4-CEYkkwlkCiUxRs9kcLncnm8rSofgCWlIoXCUXChC0aX8mWyYciZDA6DIRSsHrKlWqtS2DSavBabRSNkm5lWkWASqoAH0RmMspFlHl5gVUoaLZbrUFbXoHYZncYlMwgA)

* TypeScript

  ```ts
  export default {
    async fetch(request: Request): Promise<Response> {
      /**
       * Replace `remote` with the host you wish to send requests to
       */
      const remote = "https://example.com";


      return await fetch(remote, request);
    },
  };
  ```

* Python

  ```py
  from workers import WorkerEntrypoint
  from js import fetch


  class Default(WorkerEntrypoint):
      async def fetch(self, request):
          # Replace `remote` with the host you wish to send requests to
          remote = "https://example.com"
          return await fetch(remote, request)
  ```

* Hono

  ```ts
  import { Hono } from "hono";


  const app = new Hono();


  app.all("*", async (c) => {
    /**
     * Replace `remote` with the host you wish to send requests to
     */
    const remote = "https://example.com";


    // Forward the request to the remote server
    return await fetch(remote, c.req.raw);
  });


  export default app;
  ```
